### Name: snp.cc.match
### Title: Single SNP analysis for matched case-control data
### Aliases: snp.cc.match
### Keywords: models

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.cc.match
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))

data(pheno.dat)
mymodel <- snp.cc.match(formula1=DISEASE~SBP+DBP+SNP_1_add+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), pheno=pheno.dat, 
        geno=geno.dat)
summary(mymodel)

# example with subsetting variable
mymodel <- snp.cc.match(formula1=DISEASE~SBP+DBP+SNP_1_add+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), pheno=pheno.dat, 
        geno=geno.dat, sub=expression(SEX==1))
summary(mymodel)



