### Name: snp.long
### Title: Single SNP analysis for longitudinal data
### Aliases: snp.long
### Keywords: models

### ** Examples


data(SNPlong.dat)

# transforms SNPlong.dat to an object containing 3 columns
# per SNP - additive, dominant and recessive, where genotypes
# defined in 'baseline' serve as the baseline genotypes
longGeno.dat <- SNP2Geno(SNPlong.dat, baseline=c("AA", "GG", "V2V2"))

data(longPheno.dat)
mymodel <- snp.long(fixed=fev1f~height+weight+SNP_1_add, random=~1|id, 
        geno=longGeno.dat, pheno=longPheno.dat, form=~year|id)
summary(mymodel)

# example with a subsetting variable, looking at males only
mymodel <- snp.long(fixed=fev1f~height+weight+SNP_1_add, random=~1|id, 
        geno=longGeno.dat, pheno=longPheno.dat, form=~year|id, 
        sub=expression(sex==1))
summary(mymodel)




