### Name: snp.quant
### Title: Single SNP analysis for quantitative outcomes
### Aliases: snp.quant
### Keywords: models

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.quant
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))

data(pheno.dat)
mymodel <- snp.quant(formula1=HDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat)
summary(mymodel)

# example using a variable for which to predict marginal means
mymodel <- snp.quant(formula1=HDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat, 
        predict_variable="SNP_1_add")
summary(mymodel)

# example with a subsetting variable, looking at males only
mymodel <- snp.quant(formula1=HDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat, 
        sub=expression(SEX==1))
 



