### Name: summary.hapBin
### Title: Summarize binary haplotype analysis models
### Aliases: summary.hapBin print.summary.hapBin
### Keywords: methods

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.bin(formula1=PLAQUE~AGE+SBP+h.N1AA, 
        formula2=PLAQUE~AGE+SBP, pheno=pheno.dat, haplo=myhaplo, 
        sim=10)




