### Name: summary.hapClogit
### Title: Summarize haplotype analysis models for matched case-control
###   data
### Aliases: summary.hapClogit print.summary.hapClogit
### Keywords: methods

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)
mymodel <- haplo.cc.match(formula1=DISEASE~SBP+DBP+h.N1AA+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), haplo=myhaplo, 
        pheno=pheno.dat, sim=10)
summary(mymodel)




