### Name: summary.hapLong
### Title: Summarizing single SNP analysis models for longitudinal data
### Aliases: summary.hapLong print.summary.hapLong
### Keywords: methods

### ** Examples


data(SNPlong.dat)

# convert SNP.dat to format required by infer.haplos
longHaplo.dat <- SNP2Haplo(SNPlong.dat)

data(longPheno.dat)

myinfer<-infer.haplos(longHaplo.dat) 
myinfer$hap.freq 

myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)
mymodel <- haplo.long(fixed=fev1f~h.ACV2, random=~1|id, 
        pheno=longPheno.dat, haplo=myhaplo, form=~year|id, sim=10)
summary(mymodel)




