### Name: summary.hapSurv
### Title: Summarize haplotype analysis models for survival data
### Aliases: summary.hapSurv print.summary.hapSurv
### Keywords: methods

### ** Examples


data(SNPsurv.dat)

# convert SNP.dat to format required by infer.haplos
survHaplo.dat <- SNP2Haplo(SNPsurv.dat)

data(survPheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(survHaplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)
mymodel <- haplo.surv(formula1=Surv(time, status)~age+h.V1AA, 
        formula2=Surv(time, status)~age, haplo=myhaplo, 
        pheno=survPheno.dat, sim=10)
summary(mymodel)




