### Name: summary.snpClogit
### Title: Summarizing Single SNP analysis models for matched case-control
###   data
### Aliases: summary.snpClogit print.summary.snpClogit
### Keywords: methods

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.cc.match
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))

data(pheno.dat)
mymodel <- snp.cc.match(formula1=DISEASE~SBP+DBP+SNP_1_add+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), pheno=pheno.dat, 
        geno=geno.dat)
summary(mymodel)




