### Name: summary.snpLong
### Title: Summarizing single SNP analysis models for longitudinal data
### Aliases: summary.snpLong print.summary.snpLong
### Keywords: models

### ** Examples


data(SNPlong.dat)

# transforms SNPlong.dat to an object containing 3 columns
# per SNP - additive, dominant and recessive, where genotypes
# defined in 'baseline' serve as the baseline genotypes
longGeno.dat <- SNP2Geno(SNPlong.dat, baseline=c("AA", "GG", "V2V2"))

data(longPheno.dat)
mymodel <- snp.long(fixed=fev1f~SNP_1_add, random=~1|id, 
        geno=longGeno.dat, pheno=longPheno.dat, form=~year|id)
summary(mymodel)




