### Name: summary.snpQuant
### Title: Summarizing single SNP analysis models for quantitative outcomes
### Aliases: summary.snpQuant print.summary.snpQuant
### Keywords: methods

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.quant
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))

data(pheno.dat)
mymodel <- snp.quant(formula1=HDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat)
summary(mymodel)




