### Name: summary.snpSurv
### Title: Summarizing Single SNP analysis models for survival data
### Aliases: summary.snpSurv print.summary.snpSurv
### Keywords: methods

### ** Examples


data(SNPsurv.dat)

# transforms SNPlong.dat to an object containing 3 columns
# per SNP - additive, dominant and recessive, where genotypes
# defined in 'baseline' serve as the baseline genotypes
survGeno.dat <- SNP2Geno(SNPsurv.dat, baseline=c("V2V2", "GG", "CC"))

data(survPheno.dat)
mymodel <- snp.surv(formula1=Surv(time, status)~age+SNP_1_add, 
        formula2=Surv(time, status)~age, pheno=survPheno.dat, 
        geno=survGeno.dat)
summary(mymodel)




