### Name: survPheno.dat
### Title: Example phenotypic survival data
### Aliases: survPheno.dat
### Keywords: datasets

### ** Examples


data(SNPsurv.dat)

# transforms SNPlong.dat to an object containing 3 columns
# per SNP - additive, dominant and recessive, where genotypes
# defined in 'baseline' serve as the baseline genotypes
survGeno.dat <- SNP2Geno(SNPsurv.dat, baseline=c("V2V2", "GG", "CC"))

data(survPheno.dat)

mymodel <- snp.surv(formula1=Surv(time, status)~age+SNP_1_add, 
        formula2=Surv(time, status)~age, pheno=survPheno.dat, 
        geno=survGeno.dat)
summary(mymodel)




