infer.haplos.cc            package:SimHap            R Documentation

_I_n_f_e_r _h_a_p_l_o_t_y_p_e _c_o_n_f_i_g_u_r_a_t_i_o_n _i_n_d_e_p_e_n_d_e_n_t_l_y _i_n _c_a_s_e_s _a_n_d _c_o_n_t_r_o_l_s

_D_e_s_c_r_i_p_t_i_o_n:

     'infer.haplos.cc' generates a haplotype object to be used in
     association analysis.

_U_s_a_g_e:

     infer.haplos.cc(geno, pheno, cc.var)

_A_r_g_u_m_e_n_t_s:

    geno: a genotype data frame where each SNP is represented by two
          columns, one for each allele, in the form of 'haplo.dat'.

   pheno: a data frame containing phenotype data with at least two
          columns - a subject identifier and an indicator of disease
          status.

  cc.var: the column name of the parameter indicating disease status.
          Must be entered with quotations, e.g. ``DISEASE".

_D_e_t_a_i_l_s:

     'cc.var' must be binary, taking only values 0 or 1.

_V_a_l_u_e:

     'infer.haplos.cc' returns a list containing the following items 

  hapMat: a dataframe containing all possible haplotype configurations
          with their respective likelihoods, for each individual.

hap.freq.cases: haplotype frequencies among cases estimated using the
          EM algorithm, and the standard errors of these frequencies.

hap.freq.controls: haplotype frequencies among controls estimated using
          the EM algorithm, and the standard errors of these
          frequencies.

init.freq.cases: initial haplotype frequencies among cases to be used
          by other SimHap functions.

init.freq.controls: initial haplotype frequencies among controls to be
          used by other SimHap functions.

_N_o_t_e:

     'infer.haplos.cc' is to be used in place of 'infer.haplos' when
     haplotypes and haplotype frequencies are to be inferred
     independently in cases and controls. 'geno' and 'pheno' should
     have individuals in the same order, with the subject identifier
     column in ascending order.

_A_u_t_h_o_r(_s):

     Pamela A. McCaskie

_R_e_f_e_r_e_n_c_e_s:

     McCaskie, P.A., Carter, K.W, Hazelton, M., Palmer, L.J. (2007)
     SimHap: A comprehensive modeling framework for epidemiological
     outcomes and a multiple imputation approach to haplotypic analysis
     of population-based data, [online] www.genepi.org.au/simhap.

     Stram, D.O., Leigh Pearce, C., Bretsky, P., Freedman, M.,
     Hirschhorn, J.N., Altshuler, D., Kolonel, L.N., Henderson, B.E.,
     Thomas, D.C. (2003) Modeling and EM Estimation of
     Haplotype-Specific Relative Risks from Genotype Data for a
     Case-Control Study of Unrelated Individuals, _Human Heredity_,
     55:179-190.

_S_e_e _A_l_s_o:

     'infer.haplos', 'prepare.cc'

_E_x_a_m_p_l_e_s:

     data(SNP.dat)

     # convert SNP.dat to format required by infer.haplos
     haplo.dat <- SNP2Haplo(SNP.dat)

     data(pheno.dat)

     newdata <- prepare.cc(geno=haplo.dat, pheno=pheno.dat, cc.var="DISEASE")
     newhaplo.dat <- newdata$geno
     newpheno.dat <- newdata$pheno

     # generates haplotype frequencies and haplotype design matrix
     myinfer<-infer.haplos.cc(geno=newhaplo.dat, 
             pheno=newpheno.dat, cc.var="DISEASE")

     # prints haplotype frequencies among cases
     myinfer$hap.freq.cases

     # prints haplotype frequencies among controls
     myinfer$hap.freq.controls
      
     # generated haplo object where haplotypes with a frequency 
     # below min.freq are grouped as a category called "rare"
     myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
     mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
             pheno=newpheno.dat, haplo=myhaplo, sim=10)

