### Name: Shape matrices
### Title: Shape matrices based on spatial ranks and signed ranks
### Aliases: signrank.shape rank.shape spatial.shape
### Keywords: multivariate nonparametric htest

### ** Examples

A<-matrix(c(1,2,-3,4,3,-2,-1,0,4),ncol=3)
X<-matrix(rt(150,1),ncol=3)%*%t(A)
signrank.shape(X)
spatial.shape(X,score="sign")
to.shape(A%*%t(A))
# one-step shape estimate based on spatial ranks and covariance matrix:
spatial.shape(X,score="rank",init=cov(X),steps=1)
# effect of inner standardization:
RCov(X)
RCov(X%*%t(chol(solve(rank.shape(X)))))



