### Name: sw.plot
### Title: Plot of Observation, Network Design, Field, SW Coefficient,
###   Decomposition or Reconstruction Result
### Aliases: sw.plot
### Keywords: nonparametric

### ** Examples

### Observations of year 1967
data(temperature)
names(temperature)

# Temperatures on 939 weather stations of year 1967    
temp67 <- temperature$obs[temperature$year == 1967] 
# Locations of 939 weather stations    
latlon <- temperature$latlon[temperature$year == 1967, ]

### Draw the temperature data
sw.plot(z=temp67, latlon=latlon, type="obs")

### Network design by BUD
data(netlab)
sw.plot(z=netlab, latlon=latlon, type="network")

### SBF representation of the observations
#eta <- c(0.961,0.923,0.852,0.723,0.506)
#out.pls <- sbf(obs=temp67, latlon=latlon, netlab=netlab, eta=eta,
#    method="pls", grid.size=c(50, 100), lambda=0.89)
# observation
#sw.plot(out.pls, type="obs")
# network design
#sw.plot(out.pls, type="network")
# field 
#sw.plot(out.pls, type="field")  

### Decomposition
#out.dpls <- swd(out.pls)
# observation
#sw.plot(out.dpls, type="obs")
# network design
#sw.plot(out.dpls, type="network")   
# SBF representation of the observations
#sw.plot(out.dpls, type="field")
# sw coefficient
#sw.plot(out.dpls, type="swcoeff")
# decomposition result
#sw.plot(out.dpls, type="decom")

# Thresholding  
#out.univ <- swthresh(out.dpls, policy="universal", by.level=TRUE, 
#    type="hard", nthresh=4)  
#par(oma=c(0,0,3.5,0))
#sw.plot(out.univ, type="decom") 
#mtext("Decomposition & Threshold", side = 3, outer = TRUE, 
#    cex = 1.2, line = 1)

# Reconstruction
#out.rec <- swr(out.univ)
#sw.plot(z=out.rec, type="recon", xlab="", ylab="")



