sw.plot              package:SpherWave              R Documentation

_P_l_o_t _o_f _O_b_s_e_r_v_a_t_i_o_n, _N_e_t_w_o_r_k _D_e_s_i_g_n, _F_i_e_l_d, _S_W _C_o_e_f_f_i_c_i_e_n_t, _D_e_c_o_m_p_o_s_i_t_i_o_n _o_r _R_e_c_o_n_s_t_r_u_c_t_i_o_n _R_e_s_u_l_t

_D_e_s_c_r_i_p_t_i_o_n:

     This function performs plotting of observation, network design,
     field, SW coefficients,  decomposition or reconstruction result.

_U_s_a_g_e:

     sw.plot(sw = NULL, z = NULL, latlon = NULL, latlim = NULL, 
         lonlim = NULL, type = "field", nlevel = 256, pch = NULL, 
         cex = NULL, ...)

_A_r_g_u_m_e_n_t_s:

      sw: 'sbf' or 'swd' object

       z: observations, network design labels or reconstruction

  latlon: grid points of observation sites in degree

  latlim: range of latitudes in degree

  lonlim: range of longitudes in degree

    type: specifies the type "obs", "network", "field", "swcoeff",
          "decom" or "recon"

  nlevel: number of color levels used in legend strip

     pch: either an integer specifying a symbol or a single character
          to be used as the default in plotting points

     cex: a numerical value giving the amount by which plotting text
          and symbols should be scaled relative to the default

     ...: the usual arguments to the image function or plot function

_D_e_t_a_i_l_s:

     This function plots spherical wavelet results. Possible types are

     `"obs"' for observations

     `"network"' for network design

     `"field"' for field

     `"swcoeff"' for spherical wavelet coefficients

     `"decom"' for decomposition results

     `"recon"' for reconstruction result.

     For `sw', 'sbf' or 'swd' object must be provided. For 'sbf'
     object, type `"obs"', `"network"', `"field"' are possible whereas
     all types are possible for 'swd' object. Or specify `z' and
     `latlon' without `sw'.

_E_x_a_m_p_l_e_s:

     ### Observations of year 1967
     data(temperature)
     names(temperature)

     # Temperatures on 939 weather stations of year 1967    
     temp67 <- temperature$obs[temperature$year == 1967] 
     # Locations of 939 weather stations    
     latlon <- temperature$latlon[temperature$year == 1967, ]

     ### Draw the temperature data
     sw.plot(z=temp67, latlon=latlon, type="obs")

     ### Network design by BUD
     data(netlab)
     sw.plot(z=netlab, latlon=latlon, type="network")

     ### SBF representation of the observations
     #eta <- c(0.961,0.923,0.852,0.723,0.506)
     #out.pls <- sbf(obs=temp67, latlon=latlon, netlab=netlab, eta=eta,
     #    method="pls", grid.size=c(50, 100), lambda=0.89)
     # observation
     #sw.plot(out.pls, type="obs")
     # network design
     #sw.plot(out.pls, type="network")
     # field 
     #sw.plot(out.pls, type="field")  

     ### Decomposition
     #out.dpls <- swd(out.pls)
     # observation
     #sw.plot(out.dpls, type="obs")
     # network design
     #sw.plot(out.dpls, type="network")   
     # SBF representation of the observations
     #sw.plot(out.dpls, type="field")
     # sw coefficient
     #sw.plot(out.dpls, type="swcoeff")
     # decomposition result
     #sw.plot(out.dpls, type="decom")

     # Thresholding  
     #out.univ <- swthresh(out.dpls, policy="universal", by.level=TRUE, 
     #    type="hard", nthresh=4)  
     #par(oma=c(0,0,3.5,0))
     #sw.plot(out.univ, type="decom") 
     #mtext("Decomposition & Threshold", side = 3, outer = TRUE, 
     #    cex = 1.2, line = 1)

     # Reconstruction
     #out.rec <- swr(out.univ)
     #sw.plot(z=out.rec, type="recon", xlab="", ylab="")

