RobCor.plot              package:StatDA              R Documentation

_C_o_m_p_a_r_e_s _t_h_e _R_o_b_u_s_t _E_s_t_i_m_a_t_i_o_n _w_i_t_h _t_h_e _C_l_a_s_s_i_c_a_l

_D_e_s_c_r_i_p_t_i_o_n:

     This function compares a robust covariance (correlation)
     estimation (MCD is used) with the classical approach. A plot with
     the two ellipses will be produced and the correlation coefficients
     are quoted.

_U_s_a_g_e:

     RobCor.plot(x, y, quan = 1/2, alpha = 0.025, colC = 1, colR = 1, ltyC = 2,
     ltyR = 1, ...)

_A_r_g_u_m_e_n_t_s:

    x, y: two data vectors where the correlation should be computed 

    quan: fraction of tolerated outliers (at most 0.5) 

   alpha: quantile of chisquare distribution for outlier cutoff 

colC, colR: colour for both ellipses 

ltyC, ltyR: line type for both ellipses 

     ...: other graphical parameters 

_D_e_t_a_i_l_s:

     The covariance matrix is estimated in a robust (MCD) and non
     robust way and then both ellipses are plotted. The radi is
     calculated from the singular value decomposition and a breakpoint
     (specified quantile) for outlier cutoff.

_V_a_l_u_e:

 cor.cla: correlation of the classical estimation

 cor.rob: correlation of the robust estimation

_A_u_t_h_o_r(_s):

     Peter Filzmoser <P.Filzmoser@tuwien.ac.at>

_R_e_f_e_r_e_n_c_e_s:

     C. Reimann, P. Filzmoser, R.G. Garrett, and R. Dutter: Statistical
     Data Analysis Explained. Applied Environmental Statistics with R.
     John Wiley and Sons Inc. To appear.

_E_x_a_m_p_l_e_s:

     data(chorizon)
     Be=chorizon[,"Be"]
     Sr=chorizon[,"Sr"]
     RobCor.plot(log10(Be),log10(Sr),xlab="Be in C-horizon [mg/kg]",
     ylab="Sr in C-horizon [mg/kg]",cex.lab=1.2, pch=3, cex=0.7,
     xaxt="n", yaxt="n",colC=1,colR=1,ltyC=2,ltyR=1)

