### Name: solve_TSP
### Title: TSP solver interface
### Aliases: solve_TSP solve_TSP.TSP solve_TSP.ATSP
### Keywords: optimize

### ** Examples

data("USCA50")

## create TSP
tsp <- USCA50

## methods
methods <- c("nearest_insertion", "cheapest_insertion", "farthest_insertion", 
    "arbitrary_insertion", "nn", "repetitive_nn", "2-opt")

## calculate tours
tours <- lapply(methods, FUN = function(m) solve_TSP(tsp, method = m))
names(tours) <- methods

## use the external solver which has to be installed separately
## Not run: 
##D tours$concorde  <- solve_TSP(tsp, method = "concorde")
##D tours$linkern  <- solve_TSP(tsp, method = "linkern")
## End(Not run)

## show first tour
tours[[1]]

## compare tour lengths
opt <- 14497 # optained by concorde
tour_lengths <- c(sapply(tours, FUN = attr, "tour_length"), optimal = opt) 
dotchart(tour_lengths/opt*100-100, xlab = "percent excess over optimum")



