limits.g            package:TeachingDemos            R Documentation

_F_u_n_c_t_i_o_n_s _t_o _p_l_o_t _S_h_e_w_h_a_r_t _g _c_h_a_r_t

_D_e_s_c_r_i_p_t_i_o_n:

     These functions are used to compute statistics required by the g
     chart (geometric distribution) for use with the qcc package.

_U_s_a_g_e:

     stats.g(data, sizes)
     sd.g(data, sizes)
     limits.g(center, std.dev, sizes, conf)

_A_r_g_u_m_e_n_t_s:

    data: the observed data values 

  center: sample center statistic 

   sizes: sample sizes (not used) 

 std.dev: standard deviation of geometric distribution 

    conf: a numeric value used to compute control limits, specifying
          the number of standard deviations (if 'conf' > 1) or the
          confidence level (if 0 < 'conf' < 1).

_D_e_t_a_i_l_s:

     These functions work with the qcc package and may someday be moved
     into the qcc package.

     The g chart plots the number of non-events between events.  np
     charts do not work well when the probability of an event is rare
     (see example below).  Instead of plotting the number of events,
     the g chart plots the number of non-events between events.

_V_a_l_u_e:

     The function 'stats.g' returns a list with components 'statistics'
     and 'center'.

     The function 'sd.g' returns 'std.dev' the standard deviation
     (sqrt(1-p)/p).

     The function 'limits.g' returns a matrix with lower and upper
     control limits.

_N_o_t_e:

     The geometric distribution is quite skewed so it is best to set
     conf at the required confidence interval (0 < conf < 1) rather
     than as a multiplier of sigma.

_A_u_t_h_o_r(_s):

     Greg Snow greg.snow@intermountainmail.org

_R_e_f_e_r_e_n_c_e_s:

     Kaminsky, FC et. al. (1992): Statistical Control Charts Based on a
     Geometric Distribution, Journal of Quality Technology, 24, pp
     63-69.

     Yang, Z et. al. (2002): On the Performance of Geometric Charts
     with Estimated Control Limits, Journal of Quality Technology, 34,
     pp 448-458.

_S_e_e _A_l_s_o:

     'qcc'

_E_x_a_m_p_l_e_s:

     if(require(qcc)){
       success <- rbinom(1000, 1, 0.01)
       num.noevent <- diff(which(c(1,success)==1))-1
       qcc(success, type='np', sizes=1)
       qcc(num.noevent, type="g")
     }

