### Name: WeedMap-package
### Title: Spatial prediction of weed intensities
### Aliases: WeedMap-package WeedMap
### Keywords: package

### ** Examples


## Simulate a data set
sim <- sim.weed(nx=30, ny=20, nxy=20, nz=49,
                param.cov=c(mean=0,variance=1,nugget=0,scale=.1),
                mu=80, sigma=70, lambda=1, tau=0.2, nbin=10,
                true.field = TRUE, npix =  c(100,100), z.on.grid = TRUE)


## show the graphics
show.sim.weed(sim)

## Not run: 
##D 
##D ## make joint inference and prediction
##D res <- pred.weed(nit=10000,
##D                  thin=10,
##D                  ## data
##D                  x=sim$x,
##D                  xy=sim$xy,
##D                  y=sim$y,
##D                  z=sim$z,
##D                  wx=sim$wx,
##D                  wxy=sim$wxy,
##D                  i=sim$i,
##D                  ## init
##D                  #alpha=alpha,
##D                  #beta=beta,
##D                  lambda=1,
##D                  #tau=tau,
##D                  #kappa=kappa,
##D                  ## proposals
##D                  sd.prop.h=0.1,
##D                  sd.prop.alpha=0.1,
##D                  sd.prop.beta=0.01,
##D                  sd.prop.lambda=0.,
##D                  sd.prop.tau=0.5,
##D                  delta.prop.kappa=2,
##D                  ## priors
##D                  mprior.alpha=0.625,
##D                  vprior.alpha=1,
##D                  mprior.beta=0.0125,
##D                  vprior.beta=1,
##D                  mprior.kappa=.5,
##D                  vprior.kappa=999,
##D                  mprior.lambda=1,
##D                  vprior.lambda=1,
##D                  mprior.tau=0.1,
##D                  vprior.tau=10,
##D                  n.kappa=30,
##D                  kappa.max=5*sim$param.cov[4])
##D 
##D show.pred.weed(sim=sim,
##D                res=res,
##D                param=TRUE,
##D                pairs=TRUE,
##D                wy=FALSE,
##D                wz=FALSE,
##D                nit=res$nit,
##D                thin=res$thin,
##D                burnin=500)
##D 
##D check.model.weed(x=sim$x,
##D                  xy=sim$xy,
##D                  y=sim$y,
##D                  wx=sim$wx,
##D                  wxy=sim$wxy,
##D                  i=sim$i,
##D                  ## output of MCMC run
##D                  res=res,                           
##D                  ## options
##D                  nit=res$nit,
##D                  thin=res$thin,
##D                  burnin=500,
##D                  bin=seq(.1,.5,.05),
##D                  nqqplot=500,
##D                  nresamp=200)
##D 
## End(Not run)



