### Name: xmlTree
### Title: An internal, updatable DOM object for building XML trees
### Aliases: xmlTree
### Keywords: IO

### ** Examples

  tr <- xmlTree("Duncan")
  tr$addTag("name", attrs=c(a=1,b="xyz"), close=FALSE)
    tr$addTag("first", "Larry")
    tr$addTag("last", "User")
  tr$closeTag()
  tr$value()
  cat(saveXML(tr$value()))

  tr <- xmlTree("CDataTest")
  tr$addTag("top", close=FALSE)
  tr$addCData("x <- list(1, a='&');\nx[[2]]")
  tr$addPI("S", "plot(1:10)")
  tr$closeTag()
  cat(saveXML(tr$value()))

  # Creating a node
x = rnorm(3)
z = xmlTree("r:data", namespaces = c(r = "http://www.r-project.org"))
z$addNode("numeric", attrs = c("r:length" = length(x)))

  # shows namespace prefix on an attribute, and different from the one on the node.
  z = xmlTree()
z$addNode("r:data",  namespace = c(r = "http://www.r-project.org", omg = "http://www.omegahat.org"), close = FALSE)
x = rnorm(3)
z$addNode("r:numeric", attrs = c("omg:length" = length(x)))




