inv.res.plot              package:alr3              R Documentation

_I_n_v_e_r_s_e _r_e_s_p_o_n_s_e _p_l_o_t_s _t_o _t_r_a_n_s_f_o_r_m _t_h_e _r_e_s_p_o_n_s_e

_D_e_s_c_r_i_p_t_i_o_n:

     For a 'lm' object, draws an inverse.response plot with the
     response Y on the vertical axis and the fitted values Yhat on the
     horizontal axis.  Uses 'nls' to estimate  lambda in the function 
     Yhat = b0 + b1(Y)^(lambda). Adds the fitted curve to the plot. 
     inv.res.plot is an alias for inverse.response.plot.

_U_s_a_g_e:

     inverse.response.plot(m, lambda=c(0,1),maxiter=100,xlab=NULL,...)

_A_r_g_u_m_e_n_t_s:

       m: A lm regression object

  lambda: A vector of values for lambda.  A plot will be produced  with
          curves corresponding to these lambdas and to the least
          squares  estimate of lambda

    xlab: The horizontal axis label.  If NULL, it is constructed by the
          function.

 maxiter: Passed to 'nls', the maximum number of iterations to be used
          to compute the optimal value of lambda

     ...: Other arguments passed to 'inv.tran.plot' and then to 'plot'.

_V_a_l_u_e:

     As a side effect, a plot is produced with the response on the
     horizontal axis and fitted values on the vertical axis.   Several
     lines are added to be plot as the ols estimates of the regression
     of Yhat on Y^(lambda), interpreting lambda = 0 to be natural
     logarithms.

     Numeric output is a list with elements 

  lambda: Estimate of transformation parameter for the response

     se : Standard error of the estimate

     RSS: The residual sum of squares at the minimum

_A_u_t_h_o_r(_s):

     Sanford Weisberg, 'sandy@stat.umn.edu'

_R_e_f_e_r_e_n_c_e_s:

     S. Weisberg (2005), _Applied Linear Regression_, third edition,
     Wiley, Chapter 7

_S_e_e _A_l_s_o:

     'inv.tran.plot' and 'inv.tran.estimate', for which this is just a
     convenient front-end, and 'nls'.

_E_x_a_m_p_l_e_s:

     data(highway)
     highway$Sigs1 <- (round(highway$Sigs*highway$Len)+1)/highway$Len
     attach(highway)
     d <- data.frame(Rate=Rate,logLen=logb(Len,2),
                     logADT=logb(ADT,2),logTrks=logb(Trks,2),
                     Slim=Slim,Shld=Shld,logSigs1=logb(Sigs1,2))
     attach(d)
     m2 <- lm(Rate~logLen+logADT+logTrks+Slim+Shld+logSigs1,d)
     inv.res.plot(m2,key=c(6,2))

