inv.tran.plot              package:alr3              R Documentation

_C_h_o_o_s_e _a _p_r_e_d_i_c_t_o_r _t_r_a_n_s_f_o_r_m_a_t_i_o_n _v_i_s_u_a_l_l_y _o_r _n_u_m_e_r_i_c_a_l_l_y

_D_e_s_c_r_i_p_t_i_o_n:

     'inv.tran.plot' draws a two-dimensional scatterplot of Y versus 
     X, along with the OLS fit from the regression of Y on 
     (Y^(lam)-1)/lam.  'inv.tran.estimate' find the nonlinear least
     squares estimate of lambda and its standard error.

_U_s_a_g_e:

     inv.tran.plot(x,y,lambda=c(-1,0,1),lty=1:(1+length(lambda)),
             col=rainbow(length(lambda)+1),xlab=deparse(substitute(x)),
             ylab=deparse(substitute(y)),family="box.cox",optimal=TRUE,
             key="topleft",...)

     inv.tran.estimate(x,y,family="box.cox",...)

_A_r_g_u_m_e_n_t_s:

       x: The predictor variable 

       y: The response variable 

  lambda: The powers used in the plot.  The optimal power than
          minimizes the residual sum of squares is always added unless
          optimal is FALSE. 

  family: The transformation family to use, '"box.cox"',
          '"yeo.johnson"', or a user-defined family.

 optimal: Include the optimal value of lambda?

     lty: line types corresponding to the powers

     col: color corresponding to the powers

     key: The default is '"topleft"', in which case a legend is added
          to the top left corner of the plot; other choices include
          '"bottomright"'. If 'key' is a vector of two coordinates, the
          legend is drawn at the coordinates specified. If 'key' is
          FALSE, no key is drawn; if TRUE, you can place the key
          interactively by clicking on the plot.

    xlab: Label for the horizontal axis.

    ylab: Label for the vertical axis.

     ...: additional arguments passed to other methods.

_V_a_l_u_e:

     'inv.tran.plot' returns a graph and a data.frame with lam in the 
     first column, and the residual sum of squares from the regression
     for that lam in the second column.

     'inv.tran.estimate' returns a list with elements 'lambda' for the
     estimate, 'se' for its standard error, and 'RSS', the minimum
     value of the residual sum of squares.

_A_u_t_h_o_r(_s):

     Sanford Weisberg, sandy@stat.umn.edu

_R_e_f_e_r_e_n_c_e_s:

     Weisberg, S. (2005).  _Applied Linear Regression_, third edition.
     New York:  Wiley.

_S_e_e _A_l_s_o:

     'powtran', 'inverse.response.plot', 'optimize', 'nls'

_E_x_a_m_p_l_e_s:

     data(baeskel)
     attach(baeskel)
     inv.tran.plot(Sulfur,Tension,key=c(.6,450))
     ans <-inv.tran.estimate(Sulfur,Tension)
     # redraw the plot, including the nls estimate
     inv.tran.plot(Sulfur,Tension,lambda=c(ans$lambda,-1,0,1),key=c(.6,450))

