### Name: dissimilarity
### Title: Dissimilarity Computation
### Aliases: dissimilarity dissimilarity,matrix-method
###   dissimilarity,itemMatrix-method dissimilarity,associations-method
### Keywords: cluster models

### ** Examples

## cluster items in Groceries with support > 5%
data("Groceries")

s <- Groceries[,itemFrequency(Groceries)>0.05]
d_jaccard <- dissimilarity(s, which = "items")
plot(hclust(d_jaccard, method = "ward"))


## cluster transactions for a sample of Adult
data("Adult")
s <- sample(Adult, 200) 

##  calculate Jaccard distances and do hclust
d_jaccard <- dissimilarity(s)
plot(hclust(d_jaccard))

## calculate affinity-based distances and do hclust
d_affinity <- dissimilarity(s, method = "affinity")
plot(hclust(d_affinity))

## cluster rules
rules <- apriori(Adult)
rules <- subset(rules, subset = lift > 2)

## we need to supply the item affinities from the dataset (sample)
d_affinity <- dissimilarity(rules, method = "affinity", 
  args = list(affinity = affinity(s)))
plot(hclust(d_affinity))



