### Name: itemMatrix-class
### Title: Class ``itemMatrix'' - Sparse Binary Incidence Matrix to
###   Represent Sets of Items
### Aliases: itemMatrix-class summary.itemMatrix-class
###   show,summary.itemMatrix-method print,summary.itemMatrix-method
###   coerce,matrix,itemMatrix-method coerce,list,itemMatrix-method
###   coerce,itemMatrix,matrix-method coerce,itemMatrix,dgCMatrix-method
###   coerce,itemMatrix,ngCMatrix-method coerce,itemMatrix,list-method
###   dim,itemMatrix-method \%in\%,itemMatrix,character-method \%pin\%
###   \%pin\%,itemMatrix,character-method \%ain\%
###   \%ain\%,itemMatrix,character-method itemLabels<-,itemMatrix-method
###   itemLabels,itemMatrix-method itemLabels<- itemLabels
###   labels,itemMatrix-method labels itemInfo<-,itemMatrix-method
###   itemInfo,itemMatrix-method itemInfo<- itemInfo
###   itemsetInfo<-,itemMatrix-method itemsetInfo,itemMatrix-method
###   itemsetInfo<- itemsetInfo nitems nitems,itemMatrix-method
###   show,itemMatrix-method summary,itemMatrix-method t,ngCMatrix-method
### Keywords: classes

### ** Examples

## Generate random data and coerce data to itemMatrix.
m <- matrix(as.integer(runif(100000)>0.8), ncol=20)
dimnames(m) <- list(NULL, paste("item", c(1:20), sep=""))
i <- as(m, "itemMatrix")

## Get the number of elements (rows) in the itemMatrix.
length(i)

## Get first 5 elements (rows) of the itemMatrix as list.
as(i[1:5], "list")

## Get first 5 elements (rows) of the itemMatrix as matrix.
as(i[1:5], "matrix")

## Get first 5 elements (rows) of the itemMatrix as sparse ngCMatrix.
## Warning: for efficiency reasons, the ngCMatrix you get is transposed!
as(i[1:5], "ngCMatrix")



