### Name: ruleInduction
### Title: Rule Induction for a Set of Itemsets
### Aliases: ruleInduction ruleInduction,itemsets-method
### Keywords: models

### ** Examples

data("Adult")

## find all closed frequent itemsets
closed <- apriori(Adult, 
        parameter = list(target = "closed", support = 0.4))

## rule induction
rules <- ruleInduction(closed, Adult, control = list(verbose = TRUE))

## inspect the resulting rules
inspect(SORT(rules, by = "lift")[1:5])

## use lattice of frequent itemsets
ec  <- eclat(Adult, parameter = list(support = 0.4))
rec <- ruleInduction(ec)
inspect(rec[1:5])




