### Name: rules-class
### Title: Class ``rules'' - A Set of Rules
### Aliases: rules-class summary.rules-class show,summary.rules-method
###   coerce,rules,data.frame-method itemInfo,rules-method
###   itemLabels,rules-method items,rules-method generatingItemsets
###   generatingItemsets,rules-method labels,rules-method
###   itemLabels,rules-method lhs<-,rules-method lhs,rules-method
###   rhs<-,rules-method rhs,rules-method lhs<- lhs rhs<- rhs
###   summary,rules-method
### Keywords: classes

### ** Examples

data("Adult")

## Mine rules.
rules <- apriori(Adult, parameter = list(support = 0.4))

## Select a subset of rules using partial matching on the items 
## in the right-hand-side and a quality measure
rules.sub <- subset(rules, subset = rhs %pin% "sex" & lift > 1.3)

## Display rules.
inspect(SORT(rules.sub)[1:3])



