### Name: tidLists-class
### Title: Class ``tidLists'' - Transaction ID Lists for Items/Itemsets
### Aliases: tidLists-class tidLists_or_NULL-class
###   coerce,tidLists,matrix-method coerce,tidLists,list-method
###   coerce,tidLists,dgCMatrix-method coerce,tidLists,ngCMatrix-method
###   coerce,tidLists,transactions-method
###   coerce,transactions,tidLists-method coerce,tidLists,itemMatrix-method
###   coerce,itemMatrix,tidLists-method dim,tidLists-method
###   labels,tidLists-method itemLabels,tidLists-method
###   itemInfo,tidLists-method transactionInfo,tidLists-method
###   t,tidLists-method show,tidLists-method summary,tidLists-method
###   summary.tidLists-class show,summary.tidLists-method
### Keywords: classes

### ** Examples

## Create transaction data set.
data <- list(
  c("a","b","c"),
  c("a","b"),
  c("a","b","d"),
  c("b","e"),
  c("b","c","e"),
  c("a","d","e"),
  c("a","c"),
  c("a","b","d"),
  c("c","e"),
  c("a","b","d","e")
  )
t <- as(data, "transactions")

## Mine itemsets with tidLists.
f <- eclat(data, parameter = list(support = 0, tidLists = TRUE))

## Get dimensions of the tidLists.
dim(tidLists(f))

## Coerce tidLists to list.
as(tidLists(f), "list")

## Inspect visually. 
image(tidLists(f))



