### Name: transactions-class
### Title: Class ``transactions'' - Binary Incidence Matrix for
###   Transactions
### Aliases: transactions-class coerce,matrix,transactions-method
###   coerce,list,transactions-method coerce,transactions,matrix-method
###   coerce,transactions,list-method coerce,data.frame,transactions-method
###   coerce,transactions,data.frame-method labels,transactions-method
###   show,transactions-method transactionInfo<-,transactions-method
###   transactionInfo,transactions-method transactionInfo<- transactionInfo
###   t,transactions-method summary,transactions-method
###   summary.transactions-class show,summary.transactions-method
### Keywords: classes

### ** Examples

## 1. example: creating transactions form a list
a_list <- list(
      c("a","b","c"),
      c("a","b"),
      c("a","b","d"),
      c("c","e"),
      c("a","b","d","e")
      )

## set transaction names
names(a_list) <- paste("Tr",c(1:5), sep = "")
a_list

## coerce into transactions
trans <- as(a_list, "transactions")

## analyze transactions
summary(trans)
image(trans)

## 2. example: creating transactions from a matrix
a_matrix <- matrix(
      c(1,1,1,0,0,
        1,1,0,0,0,
        1,1,0,1,0,
        0,0,1,0,1,
        1,1,0,1,1), ncol = 5)

## set dim names
dimnames(a_matrix) <-  list(
        c("a","b","c","d","e"),
        paste("Tr",c(1:5), sep = ""))

a_matrix

## coerce
trans2 <-  as(a_matrix, "transactions")
trans2

## example 3: creating transactions from data.frame
a_data.frame <- data.frame(
        age = as.factor(c(6,8,7,6,9,5)), 
        grade = as.factor(c(1,3,1,1,4,1)))  
## note: all attributes have to be factors
a_data.frame

## coerce
trans3 <- as(a_data.frame, "transactions") 
image(trans3)

## 3. example creating from data.frame with NA
a_df <- sample(c(LETTERS[1:5], NA),10,TRUE)
a_df <- data.frame(X = a_df, Y = sample(a_df))

a_df

trans3 <- as(a_df, "transactions")
trans3
as(trans3, "data.frame")



