### Name: boolprof
### Title: Graph Profile Likelihoods for Boolean Binary Response Models
### Aliases: boolprof
### Keywords: logic optimize distribution models

### ** Examples

set.seed(50)
x1<-rnorm(1000)
x2<-rnorm(1000)
x3<-rnorm(1000)
x4<-rnorm(1000)
x5<-rnorm(1000)
x6<-rnorm(1000)
y<-1-(1-pnorm(-2+0.33*x1+0.66*x2+1*x3)*1-(pnorm(1+1.5*x4-0.25*x5)*pnorm(1+0.2*x6)))
y <- y>runif(1000)
bp <- boolprep("(a|(b&c))", y, a = ~ x1 + x2 + x3, b = ~ x4 + x5, c = ~ x6)
answer <- boolean(bp, link = c("probit", "logit", "cloglog"))

## Plot profiles
boolprof(answer)




