### Name: class2Graph
### Title: Build the Graph of Super Classes from an S4 Class Definition
### Aliases: class2Graph
### Keywords: graphs classes

### ** Examples

require("graph")
cg <- class2Graph("graphNEL") # simple :  graphNEL |-> graph
plot(cg)

if(require("Matrix")) {
   cg2 <- class2Graph("dgCMatrix")
   as(cg2, "sparseMatrix")
   plot(cg2)
   ## alternative: don't show the initial "Matrix:"
   cg2. <- class2Graph("dgCMatrix", fullNames=FALSE)
   plot(cg2.)
   ## 'simpleOnly' does not change anything here :
   stopifnot(identical(cg2.,
          class2Graph("dgCMatrix", fullNames=FALSE, simpleOnly = TRUE)))

   ## very simple, since "sparseMatrix" only extends "Matrix" :
   cg3 <- class2Graph("sparseMatrix")
   plot(cg3)
}



