### Name: subClasses
### Title: All Subclasses of a Given S4 Class
### Aliases: subClasses
### Keywords: classes

### ** Examples

##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--    or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (Cl, directOnly = TRUE, complete = TRUE, ...)
{
    if (isClassDef(Cl)) {
        cDef <- Cl
        Cl <- cDef@className
    }
    else {
        cDef <- if (complete)
            getClass(Cl)
        else getClassDef(Cl)
    }
    subs <- showExtends(cDef@subclasses, printTo = FALSE)
    if (directOnly)
        subs$what[subs$how == "directly"]
    else subs$what
  }



