### Name: direct.sum
### Title: Form the direct sum of designs.
### Aliases: direct.sum
### Keywords: design

### ** Examples

 # Generate a half replicate of a 2^3 x 3^2 experiment.  The factors are
 # to be A, B, C, D, E.  The fractional relation is to be I = ABC and the
 # DE effect is to be confounded with blocks.

 # First construct the 2^3 design, confounded in two blocks:
 d1 <- conf.design(c(1,1,1), p=2, treatment.names=LETTERS[1:3])

 # Next the 3^2 design, with DE confounded in blocks:
 d2 <- conf.design(c(1,1), p=3, treatment.names=LETTERS[4:5])

 # Now extract the principal block from the 2^3 design and form the direct
 # sum withthe 3^2 design
 dsn <- direct.sum(d1[d1$Blocks=="0",], d2)




