### Name: getTotalProbs
### Title: Calculate the probabilities of all possible outcome totals of a
###   dice roll
### Aliases: getTotalProbs
### Keywords: distribution

### ** Examples


### Don't show: 
# Not sure why this is causing check utility to fail; running the code in R produces correct result
# stopifnot(all.equal(getTotalProbs(5, 6, 2)$probabilities[11,2], 0.1356739, tolerance=.0001))
#
## End Don't show

## Rolling four six-sided dice and keeping the three highest die rolls

getTotalProbs(ndice = 4,
              nsides = 6,
              nkept = 3)

## Rolling five four-sided dice and adding 1 to each die roll

getTotalProbs(ndice = 5,
              nsides = 4,
              perDieModifier = 1)

## Rolling one twenty-sided die and adding 12 to the result

getTotalProbs(ndice = 1,
              nsides = 20,
              totalModifier = 12)




