### Name: Ectopic pregnancy
### Title: Dataset of a case-control study looking at history of abortion
###   as a risk factor for ectopic pregnancy
### Aliases: Ectopic
### Keywords: datasets

### ** Examples

data(Ectopic)
library(nnet)
use(Ectopic)
multi1 <- multinom(outc ~ hia + gravi)
summary(multi1)
mlogit.display(multi1)

# Changing referent group of outcome
ep <- outc == "EP"
ia <- outc == "IA"
deli <- outc == "Deli"
multi2 <- multinom(cbind(ia, ep, deli) ~ hia + gravi)
summary(multi2)
mlogit.display(multi2)



