### Name: cc
### Title: Odds ratio calculation and graphing
### Aliases: cc cci cs csi mhor make2x2 graph.casecontrol graph.prospective
###   labelTable
### Keywords: array

### ** Examples

data(Oswego)
.data <- Oswego
attach(.data)

# The above lines generate a hypothetical data frame. 
# In reality, one just exploits 'use("Oswego.rec"), if the file is available.
cc(ill, chocolate)
cc(ill, chocolate, design="case-control")
cs(ill, chocolate) # The outcome variable should come before the exposure.
mhor(ill, chocolate, sex)

mht1 <- table(ill, chocolate, sex)
dim(mht1)
mhor(mhtable=mht1) # same results

#    For the following table
#          chocolate
#    ill     FALSE TRUE
#     FALSE     7   22
#     TRUE     20   25
#
cci(25, 22, 20, 7)
graph.casecontrol(25, 22, 20, 7)
graph.prospective(25, 22, 20, 7)

#Alternatively
table1 <- make2x2(25,70,22,7)
cc(outcome=NULL, exposure=NULL, cctable=table1)
cs(outcome=NULL, exposure=NULL, cctable=table1)




