### Name: CI
### Title: Confidence interval of probabilty, mean and incidence
### Aliases: ci ci.default ci.binomial ci.numeric ci.poisson
### Keywords: database

### ** Examples

data(Oswego)
use(Oswego)
# logical variable
ci(ill)
# numeric variable
ci(age)
# factor
ci(sex=="M")
ci(sex=="F")

# Example of confidence interval for means
library(MASS)
use(Cars93)
car.price <- aggregate(Price, by=list(type=Type), FUN=c("mean","length","sd"))
car.price
ci.numeric(x=car.price$mean, n=car.price$length, sds=car.price$sd.Price )
 
# Example of confidence interval for probabilty
data(ANCdata)
use(ANCdata)
death1 <- death=="yes"
death.by.group <- aggregate.numeric(death1, 
        by=list(anc=anc, clinic=clinic), FUN=c("sum","length"))
death.by.group
ci.binomial(death.by.group$sum.death1, death.by.group$length)

# Example of confidence interval for incidence
data(Montana)
des(Montana)
age.Montana <- aggregate.data.frame(Montana[,1:2],
        by=list(agegr=Montana$agegr),FUN="sum")
age.Montana
ci.poisson(age.Montana$respdeath, person.time=age.Montana$personyrs)

# Keyboard input
# What is the 95 % CI of sensitivity of a test that gives all
# positive results among 40 diseased individuals
ci.binomial(40,40)

# What is the 99 % CI of incidence of a disease if the number
# of cases is 25 among 340,000 person-years
ci.poisson(25, 340000, alpha=.01) # 4.1 to 12.0 per 100,000 person-years



