### Name: Keep data
### Title: Keep a subset of variables or records
### Aliases: keepData
### Keywords: database

### ** Examples


## Record sampling
data(ANCdata)
use(ANCdata)
des()
keepData(sample=500)
des() # Note reduction of sample size to 500
use(ANCdata)
keepData(sample=.1) # Only 10
des()

## Specific record numbers
data(Compaq)
use(Compaq)
keepData(subset = 1:nrow(.data) <= 50) #First 50 records
summ()
use(Compaq)
every.seventh <- is.element(1:nrow(.data), seq(1, nrow(.data), 7))
keepData(subset = every.seventh) 
.data[1:10,]

## Records under certain conditions
data(Familydata)
use(Familydata)
des()
.data
bmi <- wt/(ht/100)^2
label.var(bmi, "Body mass index (kg/m2)")
keepData(subset = ht > 120)
.data # Which record is missing?

## Reduction of variables
## Removal consecutive variables
use(Familydata)
keepData(select = -(age:ht)) # Variables from 'age' to 'ht' removed
des() 
## A better alternative would be:
use(Familydata)
keepData(exclude = age:ht) 
des() 
keepData(select = -c(1,3)) # Further removal of the first and 
                                       # the third variables 
des()
codebook()
## Targeting only a certain variables
data(Oswego)
use(Oswego)
des()
keepData(select = c(age, sex, ill, cakes:fruitsalad))
des() 
keepData(select = c(1,2,5:7)) # Retain all variables except the third 
                                  #the the fourth
des()
# Note the number of brackets '(subset)'


## Wildcard
use(Oswego)
des()
keepData(select = "c*") # The wildcard must be embraced by quotes
des()

use(Oswego)
des()
keepData(exclude = "on*") # Variables having names starting with "on" removed
keepData(exclude = "???") # Variables having names in 3 characters removed
des() # Which are missing?




