### Name: Variable manipulation
### Title: Variable manipulation
### Aliases: label.var pack sortBy
### Keywords: database

### ** Examples

data(Oswego)
use(Oswego)

sbp <- c(120, 100, 110, 120, 140, 120,  NA,  NA) 
dbp <- c( 80,  80,  70,  80,  70,  NA,  70,  60)
.data <- data.frame(sbp, dbp)
attach(.data, warn.conflicts=FALSE)

# The above lines generate a hypothetical data frame. In reality,
# one just exploits 'use("datafile")', if the "datafile" exists.
des()
label.var(sbp, "systolic BP")
label.var(dbp, "diastolic BP")
des()
pp <- sbp - dbp # This is a new free vector.
summ(pp) # unlabelled
label.var(pp, "pulse pressure")
des()
summ(pp)

## Silly things to do. Just for demonstration.
pp2 <- pp^2
pp3 <- pp^3
pack()

age <- c(37, 32, 24, 33, 31, 30, 26, 25)
age2 <- age^2
sortBy(age)
pack()
des()
.data
sortBy(age, decreasing=TRUE)
.data



