### Name: recode
### Title: Recode variable(s)
### Aliases: recode
### Keywords: database

### ** Examples

age       <- c( 37,  99,  24,  33,  31,  30,  26,  25) 
systolic  <- c(120, 120, 110, 120, 130, 120, 888, 999) 
diastolic <- c( 80,  80,  70,  80,  70, 999,  70,  60)
sick      <- c(  1,   2,   2,   1,   2,   2,   2,   NA)
treated   <- c(  2,   1,   2,   2,   1,   2,   2,   1)
yesno     <- c("Y", "N")
sick      <- factor(sick, labels=yesno)
treated   <- factor(treated, labels=yesno)
.data     <- data.frame(age, systolic, diastolic, sick, treated)
attach(.data, warn.conflicts=FALSE)
pack()
# 'pack() integate all variables into .data
# to avoid confusion with free vectors.

# The above lines generate a hypothetical data frame. 
# In reality, one just exploits 'use("datafile")', if the "datafile" exists.
.data
summ()
recode(age, old.value=99, new.value=NA)
recode(vars=c(systolic, diastolic), 999, NA) # The value 888 is not recoded.
recode(systolic, systolic > 250, NA)
summ()
table(sick, treated)
recode(vars=c(sick, treated), old.value="Y", new.value="yes")
table(sick, treated)

# Recode both sick and treated to "N" if sick status is missing. 
recode(vars=c(sick,treated), is.na(sick), new.value="N") 
table(sick, treated) 



