### Name: Risk.display
### Title: Tables for multivariate odds ratio, incidence density etc
### Aliases: logistic.display regress.display idr.display mlogit.display
###   ordinal.or.display tableGlm
### Keywords: database

### ** Examples

model0 <- glm(case ~ induced + spontaneous, family=binomial, data=infert)
summary(model0)
logistic.display(model0)

data(ANCdata)
glm1 <- glm(death ~ anc + clinic, family=binomial, data=ANCdata)
logistic.display(glm1)
 
library(MASS)
model1 <- glm(Origin ~ Weight + AirBags + DriveTrain, family=binomial, data=Cars93)
logistic.display(model1, decimal=3, crude.p.value=TRUE)

reg1 <- lm(Price ~ Weight + AirBags + DriveTrain, data=Cars93)
regress.display(reg1)

reg2 <- glm(Price ~ Weight + AirBags + DriveTrain, data=Cars93)
regress.display(reg2)

library(nnet)

# Ordinal logistic regression
options(contrasts = c("contr.treatment", "contr.poly"))
house.plr <- polr(Sat ~ Infl + Type + Cont, weights = Freq, data = housing)
house.plr
ordinal.or.display(house.plr)

# Polytomous or multinomial logistic regression
house.multinom <- multinom(Sat ~ Infl + Type + Cont, weights = Freq, 
        data = housing)
summary(house.multinom)
mlogit.display(house.multinom, alpha=.01) # with 99 percent confidence limits.



