### Name: tableStack
### Title: Tabulation of variables in a stack form
### Aliases: tableStack
### Keywords: aplot

### ** Examples

data(Oswego)
use(Oswego)
des()
tableStack(bakedham:fruitsalad)
tableStack(bakedham:fruitsalad, by= ill)
tableStack(bakedham:fruitsalad, by= ill, prevalence=FALSE)
tableStack(bakedham:fruitsalad, by= ill, prevalence=FALSE, percent=FALSE)
tableStack(bakedham:fruitsalad, by= ill, prevalence=FALSE, 
  percent=FALSE, name.test=FALSE)

data(Cars93, package="MASS")
use(Cars93)
des()
tableStack(vars=4:25, by=Origin)

data(Attitudes)
use(Attitudes)
## Please use full screen of Rconsole
## for better display of the labels.
tableStack(qa1:qa18)
tableStack(qa1:qa18, reverse=TRUE) -> a
a
## Components of 'a' have appropriate items reversed
a$mean.score -> mean.score 
a$total.score -> total.score
pack()
tableStack(c(qa1,qa13:qa18,mean.score,total.score), by=sex, test=FALSE)
tableStack(c(qa15, qa17, mean.score:total.score), by=sex, iqr=c(qa17,total.score))
tableStack(c(qa15, qa17, mean.score:total.score), by=dep, iqr=c(qa17,total.score))
## 'vars' can be mixture of different classes of variables
highscore <- mean.score > 4
label.var(highscore, "high score")
tableStack(mean.score:highscore, by=sex, iqr=total.score)

data(Ectopic)
use(Ectopic)
des()
tableStack(vars=3:4, by=outc)
tableStack(vars=3:4, by=outc, percent="none")
tableStack(vars=3:4, by=outc, prevalence = FALSE)
tableStack(vars=3:4, by=outc, name.test = FALSE)

## Beware of small sample sizes in the last command


