### Name: boot.sequence
### Title: Bootstrap a sequence.
### Aliases: boot.sequence
### Keywords: misc

### ** Examples

# Simulate 1000 uniform random variables.
x <- runif(1000)

# Perform runs declustering with run length = 1 and 90th percentile as threshold.
u <- quantile(x, 0.9)
z <- x > u
dec <- decluster.runs(z, 1)

# Make sure the estimated run length is not zero before doing the rest.
if( dec[["par"]] != 0) {
   # Set up the matrices for bootstrapping.
   mat <- boot.matrix(dec, x)
   # Bootstrap with 500 iterations.
   eib <- numeric(500)
   for( i in 1:500) {
           set.seed(i)
           zb <- boot.sequence(mat[[1]],mat[[2]],u) > u
           eib[i] <- exi.intervals(zb)
           } # end of for 'i' loop.
   # Obtain bootstrapped 95th percentile confidence intervals.
   conf.int <- quantile( eib, c((1-0.95)/2,(1+0.95)/2))
} # end of if run length not zero stmt.



