### Name: dclust
### Title: Decluster data by runs declustering.
### Aliases: dclust
### Keywords: manip

### ** Examples

# Load a dataset.
data(Tphap)

plot( Tphap[,"MaxT"])
abline( h=115)

# Decluster using a threshold of 115 degrees and a run length of 'r=1'.
temp <- dclust(xdat=Tphap[,"MaxT"], u=115, r=1, cluster.by = Tphap[,"Year"])
temp[["ncluster"]] # See how many clusters were found.

# Now do the same as above, but with a run length of 3 for comparison.
# Note: 'r=2' gives same clusters as 'r=1' for these data.
temp2 <- dclust(xdat=Tphap[,"MaxT"], u=115, r=3, cluster.by = Tphap[,"Year"])
temp2[["ncluster"]]

# See Gilleland et al. (2005) for more.



