### Name: decluster.runs
### Title: Declustering Extremes
### Aliases: decluster.runs decluster.intervals
### Keywords: misc

### ** Examples

# Simulate a dependent series of random variables.
x <- runif(1000,-1,1)
x[2:1000] <- x[1:999]*0.6
# -- DON'T RUN
# pacf( x)

# use runs and intervals declustering using the 90th percentile as the threshold.
u <- quantile(x, 0.9)
z <- x > u
exi.intervals(z)
tmp1 <- decluster.runs(z, 1)
tmp2 <- decluster.intervals( z, exi.intervals(z))



