### Name: fpp
### Title: Point Process
### Aliases: fpp
### Keywords: misc

### ** Examples

# load Fort Collins, CO precipitation dataset.
data(FtCoPrec)

# Perform a simple point process model fit.
x <- FtCoPrec[,"Prec"]
fit <- fpp( x, 0.395)
pp.diag( fit)

# Add seasonal covariates.
Time <- FtCoPrec[,"obs"]
angle <- (2*pi*Time)/365.25
s <- cbind( sin( angle), cos( angle))
fit <- fpp( xdat=x, threshold=0.395, npy=365.25, ydat=s, mul=1:2, sigl=1:2, siglink=exp)
pp.diag( fit)



