### Name: ArmaInterface
### Title: Integrated ARMA Time Series Modelling
### Aliases: ArmaInterface fARMA fARMA-class armaSim armaFit show.fARMA
###   show,fARMA-method plot.fARMA summary.fARMA predict.fARMA fitted.fARMA
###   coef.fARMA coefficients.fARMA residuals.fARMA
### Keywords: models

### ** Examples

## armaSim -
   # Simulation:
   x = armaSim(model = list(ar = c(0.5, -0.5), ma = 0.1), n = 1000)
   
## armaFit -
   # Estimate the Parameters:
   fit = armaFit(~ arma(2, 1), data = x)
   print(fit)
      
## summary -
   # Diagnostic Analysis:
   par(mfrow = c(2, 2), cex = 0.7)
   summary(fit, which =  "all")
   
## plot - 
   # Interactive Plots:
   # par(mfrow = c(1, 1))
   # plot(fit)
   
## predict -
   # Forecast 5 Steps Ahead:
   par(mfrow = c(1, 1))
   predict(fit, 5)
   
## armaFit -
   # Alternative Calls:
   TS = as.timeSeries(data(msft.dat))
   armaFit(formula = diff(log(Close)) ~ ar(5), data = TS)
   armaFit(Close ~ ar(5), data = returnSeries(TS, digits = 12))
   TS.RET = returnSeries(TS, digits = 12)
   armaFit(Close ~ ar(5), TS.RET)
   armaFit(Close ~ ar(5), as.data.frame(TS.RET))
   armaFit(~ ar(5), as.vector(TS.RET[, "Close"]))
   armaFit(~ ar(5), as.ts(TS.RET)[, "Close"])
   attach(TS.RET)
   armaFit(Close ~ ar(5))
   detach(TS.RET)



