### Name: TimeDateSubsets
### Title: timeDate Class, Subsetting
### Aliases: TimeDateSubsets isWeekday isWeekend isBizday isHoliday
###   getDayOfWeek getDayOfYear length.timeDate [.timeDate window.timeDate
###   cut.timeDate start.timeDate end.timeDate blockStart blockEnd
### Keywords: chron

### ** Examples
  
## Dates in April, currentYear: 
   tS = timeSequence(
      from = paste(currentYear, "-04-01", sep = ""),
      to = paste(currentYear, "-04-30", sep = ""))
   tS
    
## Subset of Weekends:
   isWeekend(tS)
   tS[isWeekend(tS)]
   
## Subset Wednesdays:
   getDayOfWeek(tS)
   tS[getDayOfWeek(tS) == "Wed"]
   
## Subset Business Days at NYSE:
   holidayNYSE()
   isBizday(tS, holidayNYSE())
   tS[isBizday(tS, holidayNYSE())]
     
## [ - Subsetting First Five Days:
   tS[1:5]   
   
## window - 
   GoodFriday(currentYear)
   EasterMonday(currentYear)
   window(tS, 
      start = GoodFriday(currentYear), 
      end = EasterMonday(currentYear))
   
## [ - 
   # All dates after Easter Monday:
   tS[tS > EasterMonday(currentYear)]
   
## Subset Start and End Date:
   c(start(tS), end(tS))



