### Name: PortfolioClass
### Title: Portfolio Class
### Aliases: PortfolioClass fPORTFOLIO fPORTFOLIO-class show.fPORTFOLIO
###   show,fPORTFOLIO-method feasiblePortfolio efficientPortfolio
###   cmlPortfolio tangencyPortfolio minvariancePortfolio portfolioFrontier
###   plot.fPORTFOLIO summary.fPORTFOLIO
### Keywords: models

### ** Examples

## minvariancePortfolio -
   # Load Data and Convert to timeSeries Object:
   Data = as.timeSeries(data(smallcap.ts))
   Data = Data[, c("BKE", "GG", "GYMB", "KRON")]
   Data
   # Set Default Specifications:
   Spec = portfolioSpec()
   Spec
   # Allow for unlimited Short Selling:
   Constraints = "Short"
   # Compute Short Selling Minimum Variance Portfolio
   minvariancePortfolio(Data, Spec, Constraints)
    
## portfolioFrontier -
   # Modify Constraints - Now Long Only Constraints:
   Constraint = c("minW[1:nAssets]=0")
   # Calculation of the Efficient Frontier
   frontier = portfolioFrontier(Data, Spec, Constraint)
   print(frontier)
    
## plot -
   # Plot Efficient Frontier with Minimum Variance Portfolio
   # plot(frontier, which = c(1, 3))
    
## frontierSlider -
   # Try Frontier Slider:
   # frontierSlider(frontier)



