### Name: PortfolioPlots
### Title: Portfolio Plots
### Aliases: PortfolioPlots frontierPlot weightsPlot attributesPlot
###   covRiskBudgetsPlot tailRiskBudgetsPlot weightsPie attributesPie
###   covRiskBudgetsPie tailRiskBudgetsPie covEllipsesPlot
### Keywords: models

### ** Examples

## portfolioFrontier -
   # Load Data:
   Data = as.timeSeries(data(smallcap.ts))
   Data = Data[, c("BKE", "GG", "GYMB", "KRON")]
   Data
   # Compute Long Only Efficient Frontier
   frontier = portfolioFrontier(Data)
   frontier
   
## frontierPlot -  
   # Plot Upper Part of Frontier:
   # frontierPlot(frontier, frontier = "upper")
   # Adding Lower Part to Plot
   # frontierPlot(frontier, frontier = "lower", add = TRUE)
    
## weightsPlot -
   # View Weights Plot:
   # weightsPlot(frontier)
    
## attributesPlot -
   # View Attributes Plot:
   # attributesPlot(frontier, legend = TRUE)



